/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.api.VWMapDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.mapui.VWBaseWorkflowMapPane;
import filenet.vw.toolkit.utils.mapui.VWBaseWorkflowPane;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.IVWSortItem;

public class VWMap
implements IVWSortItem {
    protected VWBaseWorkflowPane m_workflowPane = null;
    protected VWMapDefinition m_vwMapDef = null;
    protected VWBaseWorkflowMapPane m_mapPane = null;

    public VWMap(VWBaseWorkflowPane workflowPane, VWMapDefinition mapDef) {
        this.m_workflowPane = workflowPane;
        this.m_vwMapDef = mapDef;
    }

    public VWMapDefinition getMapDefinition() {
        return this.m_vwMapDef;
    }

    public void setMapDefinition(VWMapDefinition mapDef) {
        this.m_vwMapDef = mapDef;
    }

    public int getMapId() {
        try {
            if (this.m_vwMapDef != null) {
                return this.m_vwMapDef.getMapId();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return 0;
    }

    public boolean isMainMap() {
        try {
            if (this.m_vwMapDef != null) {
                return VWStringUtils.compare("Workflow", this.m_vwMapDef.getName()) == 0;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    public boolean isMapPaneAvailable() {
        return this.m_mapPane != null;
    }

    public VWBaseWorkflowMapPane getMapPane() {
        if (this.m_mapPane == null && this.m_vwMapDef != null && this.m_workflowPane != null) {
            this.m_mapPane = this.m_workflowPane.createMapPane(this);
        }
        return this.m_mapPane;
    }

    public VWBaseWorkflowPane getWorkflowPane() {
        return this.m_workflowPane;
    }

    public String toString() {
        return this.getName();
    }

    public void removeReferences() {
        this.m_workflowPane = null;
        this.m_vwMapDef = null;
        if (this.m_mapPane != null) {
            this.m_mapPane.removeReferences();
            this.m_mapPane = null;
        }
    }

    public String getName() {
        if (this.m_vwMapDef != null) {
            return this.m_vwMapDef.getName();
        }
        return VWResource.s_unknown;
    }
}

